#include "KPCIDIO.h"

typedef interface tagKPCIDIOLib_IKPCIPIO_Interface KPCIDIOLib_IKPCIPIO_Interface;

typedef struct tagKPCIDIOLib_IKPCIPIO_VTable
{
	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *QueryInterface )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This, 
	                                                         REFIID riid, 
	                                                         void __RPC_FAR *__RPC_FAR *ppvObject);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *AddRef )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *Release )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfoCount )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This, 
	                                                           UINT __RPC_FAR *pctinfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfo )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This, 
	                                                      UINT iTInfo, 
	                                                      LCID lcid, 
	                                                      ITypeInfo __RPC_FAR *__RPC_FAR *ppTInfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetIDsOfNames )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This, 
	                                                        REFIID riid, 
	                                                        LPOLESTR __RPC_FAR *rgszNames, 
	                                                        UINT cNames, 
	                                                        LCID lcid, 
	                                                        DISPID __RPC_FAR *rgDispId);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Invoke )( KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR * This, 
	                                                 DISPID dispIdMember, 
	                                                 REFIID riid, 
	                                                 LCID lcid, 
	                                                 WORD wFlags, 
	                                                 DISPPARAMS __RPC_FAR *pDispParams, 
	                                                 VARIANT __RPC_FAR *pVarResult, 
	                                                 EXCEPINFO __RPC_FAR *pExcepInfo, 
	                                                 UINT __RPC_FAR *puArgErr);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *OpenDevice_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This, 
	                                                     long device);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *CloseDevice_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Read_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This, 
	                                               short offset, 
	                                               unsigned char *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Write_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This, 
	                                                short offset, 
	                                                unsigned char value);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetOpenCount_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This, 
	                                                       long *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetDevice_) (KPCIDIOLib_IKPCIPIO_Interface __RPC_FAR *This, 
	                                                    long *__returnValue);

} KPCIDIOLib_IKPCIPIO_VTable;

typedef interface tagKPCIDIOLib_IKPCIPIO_Interface
{
	CONST_VTBL KPCIDIOLib_IKPCIPIO_VTable __RPC_FAR *lpVtbl;
} KPCIDIOLib_IKPCIPIO_Interface;

typedef interface tagKPCIDIOLib_IHardware_Interface KPCIDIOLib_IHardware_Interface;

typedef struct tagKPCIDIOLib_IHardware_VTable
{
	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *QueryInterface )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This, 
	                                                         REFIID riid, 
	                                                         void __RPC_FAR *__RPC_FAR *ppvObject);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *AddRef )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This);

	ULONG ( STDMETHODCALLTYPE __RPC_FAR *Release )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfoCount )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This, 
	                                                           UINT __RPC_FAR *pctinfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetTypeInfo )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This, 
	                                                      UINT iTInfo, 
	                                                      LCID lcid, 
	                                                      ITypeInfo __RPC_FAR *__RPC_FAR *ppTInfo);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *GetIDsOfNames )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This, 
	                                                        REFIID riid, 
	                                                        LPOLESTR __RPC_FAR *rgszNames, 
	                                                        UINT cNames, 
	                                                        LCID lcid, 
	                                                        DISPID __RPC_FAR *rgDispId);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *Invoke )( KPCIDIOLib_IHardware_Interface __RPC_FAR * This, 
	                                                 DISPID dispIdMember, 
	                                                 REFIID riid, 
	                                                 LCID lcid, 
	                                                 WORD wFlags, 
	                                                 DISPPARAMS __RPC_FAR *pDispParams, 
	                                                 VARIANT __RPC_FAR *pVarResult, 
	                                                 EXCEPINFO __RPC_FAR *pExcepInfo, 
	                                                 UINT __RPC_FAR *puArgErr);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *ReadRegister8_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                        short offset, 
	                                                        unsigned char *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *ReadRegister16_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                         short offset, 
	                                                         short *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *ReadRegister32_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                         short offset, 
	                                                         long *__returnValue);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *WriteRegister8_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                         short offset, 
	                                                         unsigned char value);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *WriteRegister16_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                          short offset, 
	                                                          short value);

	HRESULT ( STDMETHODCALLTYPE __RPC_FAR *WriteRegister32_) (KPCIDIOLib_IHardware_Interface __RPC_FAR *This, 
	                                                          short offset, 
	                                                          long value);

} KPCIDIOLib_IHardware_VTable;

typedef interface tagKPCIDIOLib_IHardware_Interface
{
	CONST_VTBL KPCIDIOLib_IHardware_VTable __RPC_FAR *lpVtbl;
} KPCIDIOLib_IHardware_Interface;

HRESULT CVIFUNC KPCIDIOLib_NewIKPCIPIO (const char *server,
                                        int supportMultithreading, LCID locale,
                                        int reserved, CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x4662E92D, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_CreateObjectByClassIdEx (&clsid, server, &iid,
	                                       supportMultithreading, locale,
	                                       reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_OpenIKPCIPIO (const char *fileName,
                                         const char *server,
                                         int supportMultithreading, LCID locale,
                                         int reserved, CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x4662E92D, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_LoadObjectFromFileByClassIdEx (fileName, &clsid, server,
	                                             &iid, supportMultithreading,
	                                             locale, reserved,
	                                             objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_ActiveIKPCIPIO (const char *server,
                                           int supportMultithreading,
                                           LCID locale, int reserved,
                                           CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x4662E92D, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_GetActiveObjectByClassIdEx (&clsid, server, &iid,
	                                          supportMultithreading, locale,
	                                          reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOOpenDevice (CAObjHandle objectHandle,
                                               ERRORINFO *errorInfo, long device)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->OpenDevice_ (__dualIFacePtr, device));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOCloseDevice (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->CloseDevice_ (__dualIFacePtr));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIORead (CAObjHandle objectHandle,
                                         ERRORINFO *errorInfo, short offset,
                                         unsigned char *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->Read_ (__dualIFacePtr, offset,
	                                           returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOWrite (CAObjHandle objectHandle,
                                          ERRORINFO *errorInfo, short offset,
                                          unsigned char value)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->Write_ (__dualIFacePtr, offset, value));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOGetOpenCount (CAObjHandle objectHandle,
                                                 ERRORINFO *errorInfo,
                                                 long *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->GetOpenCount_ (__dualIFacePtr,
	                                                   returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IKPCIPIOGetDevice (CAObjHandle objectHandle,
                                              ERRORINFO *errorInfo,
                                              long *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IKPCIPIO_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x4662E92D, 0x0439, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->GetDevice_ (__dualIFacePtr,
	                                                returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_NewIHardware (const char *server,
                                         int supportMultithreading, LCID locale,
                                         int reserved, CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x97F3D954, 0x169, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_CreateObjectByClassIdEx (&clsid, server, &iid,
	                                       supportMultithreading, locale,
	                                       reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_OpenIHardware (const char *fileName,
                                          const char *server,
                                          int supportMultithreading, LCID locale,
                                          int reserved,
                                          CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x97F3D954, 0x169, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_LoadObjectFromFileByClassIdEx (fileName, &clsid, server,
	                                             &iid, supportMultithreading,
	                                             locale, reserved,
	                                             objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_ActiveIHardware (const char *server,
                                            int supportMultithreading,
                                            LCID locale, int reserved,
                                            CAObjHandle *objectHandle)
{
	HRESULT __result;
	GUID clsid = {0x4662E92E, 0x439, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	              0x3C, 0x3E};
	GUID iid = {0x97F3D954, 0x169, 0x11D2, 0x88, 0xB4, 0x0, 0xC0, 0x9F, 0x0,
	            0x3C, 0x3E};

	__result = CA_GetActiveObjectByClassIdEx (&clsid, server, &iid,
	                                          supportMultithreading, locale,
	                                          reserved, objectHandle);

	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister8 (CAObjHandle objectHandle,
                                                   ERRORINFO *errorInfo,
                                                   short offset,
                                                   unsigned char *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->ReadRegister8_ (__dualIFacePtr, offset,
	                                                    returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister16 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    short *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->ReadRegister16_ (__dualIFacePtr,
	                                                     offset, returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareReadRegister32 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    long *returnValue)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->ReadRegister32_ (__dualIFacePtr,
	                                                     offset, returnValue));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister8 (CAObjHandle objectHandle,
                                                    ERRORINFO *errorInfo,
                                                    short offset,
                                                    unsigned char value)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->WriteRegister8_ (__dualIFacePtr,
	                                                     offset, value));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister16 (CAObjHandle objectHandle,
                                                     ERRORINFO *errorInfo,
                                                     short offset, short value)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->WriteRegister16_ (__dualIFacePtr,
	                                                      offset, value));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}

HRESULT CVIFUNC KPCIDIOLib_IHardwareWriteRegister32 (CAObjHandle objectHandle,
                                                     ERRORINFO *errorInfo,
                                                     short offset, long value)
{
	HRESULT __result;
	KPCIDIOLib_IHardware_Interface * __dualIFacePtr = 0;
	GUID __IID = {0x97F3D954, 0x0169, 0x11D2, 0x88, 0xB4, 0x00, 0xC0, 0x9F, 0x00, 0x3C, 0x3E};
	int __didAddRef;
	int __errorInfoPresent;

	__caErrChk (CA_GetInterfaceFromObjHandle (objectHandle, &__IID, 0,
	                                          &__dualIFacePtr, &__didAddRef));
	__caErrChk (__dualIFacePtr->lpVtbl->WriteRegister32_ (__dualIFacePtr,
	                                                      offset, value));

Error:
	if (__dualIFacePtr && __didAddRef)
		__dualIFacePtr->lpVtbl->Release (__dualIFacePtr);
	CA_FillErrorInfo (__result, errorInfo, &__errorInfoPresent);
	if (__errorInfoPresent)
		__result = DISP_E_EXCEPTION;
	return __result;
}
